package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-27
 */
@Service
@Slf4j
public class CategoryBeforeDiscountReplyRateRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private ConVariableDetailSdkService conVariableDetailSdkService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "categoryBeforeDiscountReplyRate";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "品类折前回复量达成率（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 是否可配置
     *
     * @return 是否可配置
     */
    @Override
    public Boolean isConfigurable() {
        return true;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        SalesPlanDto salesPlanDto = new SalesPlanDto();

        //参数
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesPlanDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesPlanDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
            salesPlanDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty(calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
            salesPlanDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
            salesPlanDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("客户编码、销售组、销售部门全部为空");
        }

        //包含产品
        List<ConVariableDetailVo> conVariableDetailVos = conVariableDetailSdkService.findConVariableList(calculateDto.getAuditFormulaCode(), this.getVariableCode());
        List<String> productCodes = conVariableDetailVos.stream().filter(e -> StringUtils.equals(ConItemTypeEnum.INCLUDE_GOODS.getCode(), e.getItemType())).map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productCodes)) {
            return resultMap;
        }

        salesDataDto.setProductCodes(productCodes);
        salesPlanDto.setSalesProductCodeList(productCodes);
        if (!CollectionUtils.isEmpty(conVariableDetailVos)) {
            List<ConVariableDetailVo> filterList = conVariableDetailVos.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = conVariableDetailVos.get(0);
                salesDataDto.setStartTimeOrDate(DateUtil.format(variableDetailVo.getBeginTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                salesDataDto.setEndTimeOrDate(DateUtil.format(variableDetailVo.getEndTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
        }
        if (StringUtils.isEmpty(salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty(salesDataDto.getEndTimeOrDate())){
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            salesDataDto.setStartTimeOrDate(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            salesDataDto.setEndTimeOrDate(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }
        salesPlanDto.setYearMonthLyBegin(salesDataDto.getStartTimeOrDate().substring(0, 7));
        salesPlanDto.setYearMonthLyEnd(salesDataDto.getEndTimeOrDate().substring(0, 7));
        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));

        //主体日销售报表
        List<MainOnedaySalesDataVo> salesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        BigDecimal salesAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(salesDataVos)) {
            BigDecimal minusDiscountFrontTaxSaleAmount = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusDiscountFrontTaxSaleAmount())).map(MainOnedaySalesDataVo::getMinusDiscountFrontTaxSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal minusMilkCardDiscountBehindOrderAmountToB = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusMilkCardDiscountBehindOrderAmountToB())).map(MainOnedaySalesDataVo::getMinusMilkCardDiscountBehindOrderAmountToB).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal minusMilkCardDiscountBehindOrderAmountToC = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusMilkCardDiscountBehindOrderAmountToC())).map(MainOnedaySalesDataVo::getMinusMilkCardDiscountBehindOrderAmountToC).reduce(BigDecimal.ZERO, BigDecimal::add);
            salesAmount = minusDiscountFrontTaxSaleAmount.add(minusMilkCardDiscountBehindOrderAmountToB).add(minusMilkCardDiscountBehindOrderAmountToC);
        }
        //销售计划
        List<SalesPlanVo> salesPlanVos = salesPlanService.findByConditions(salesPlanDto);
        BigDecimal restoreAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(salesPlanVos)) {
            restoreAmount = salesPlanVos.stream().filter(e -> Objects.nonNull(e.getRestoreAmount())).map(SalesPlanVo::getRestoreAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (BigDecimal.ZERO.compareTo(restoreAmount) == 0) {
            return resultMap;
        }

        BigDecimal rate = salesAmount.divide(restoreAmount, 8, RoundingMode.HALF_UP);
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}
