package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-23
 */
@Slf4j
@Service
public class CompanyFeeRateRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "companyFeeRate";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "公司承担比例（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "细案明细编码不能为空");
        List<ActivityDetailPlanItemVo> resultList = activityDetailPlanItemService.findByItemCodes(Lists.newArrayList(calculateDto.getDetailPlanItemCode()));
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(resultList)) {
            return resultMap;
        }
        ActivityDetailPlanItemVo itemVo = resultList.get(0);
        BigDecimal feeAmount = Objects.nonNull(itemVo.getFeeAmount()) ? itemVo.getFeeAmount() : BigDecimal.ZERO;
        BigDecimal totalFeeAmount = Objects.nonNull(itemVo.getTotalFeeAmount()) ? itemVo.getTotalFeeAmount() : BigDecimal.ZERO;
        BigDecimal rate = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(totalFeeAmount) != 0) {
            rate = feeAmount.divide(totalFeeAmount, 8, RoundingMode.HALF_UP);
        }
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}
