package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.configure.common.ConVariableRegisterParamHandler;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-05-10
 */
@Slf4j
@Service
public class CustomerLevelRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public String getVariableCode() {
        return "customerLevel";
    }

    @Override
    public String getVariableName() {
        return "客户等级（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码为空！");
        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(Lists.newArrayList(calculateDto.getCustomerCode()));
        Validate.notEmpty(customerVos, "客户信息不存在！");
        String customerLevel = customerVos.get(0).getCustomerLevel();
        if (StringUtils.isEmpty(customerLevel)) {
            log.error("客户信息-客户等级为空！");
            return resultMap;
        }

        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode(DictConstant.MDM_CUSTOMER_LEVEL, customerLevel);
        Validate.notNull(dictDataVo, "客户等级[%s]在数据字典[%s]不存在！", customerLevel, DictConstant.MDM_CUSTOMER_LEVEL);
        Validate.notBlank(dictDataVo.getDictDesc(), "客户等级[%s]在数据字典[%s]未配置对应描述！", customerLevel, DictConstant.MDM_CUSTOMER_LEVEL);

        try {
            BigDecimal value = new BigDecimal(dictDataVo.getDictDesc());
            resultMap.put(this.getVariableCode(), value);
        } catch (Exception e) {
            log.error("客户等级（主体）[" + customerLevel + "]转换等级对应值异常!" + e.getMessage(), e);
            throw new RuntimeException("客户等级[" + customerLevel + "]在数据字典[" + DictConstant.MDM_CUSTOMER_LEVEL + "]描述格式错误，只能是纯数字！");
        }
        return resultMap;
    }
}
