package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.configure.common.ConVariableRegisterParamHandler;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-05-10
 */
@Slf4j
@Service
public class LastTenDaysMarkProductQuantityRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ConVariableRegisterParamHandler conVariableRegisterParamHandler;

    @Override
    public String getVariableCode() {
        return "lastTenDaysMarkProductQuantity";
    }

    @Override
    public String getVariableName() {
        return "下旬指定产品件数（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public Boolean isConfigurable() {
        return true;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List<MainOnedaySalesDataVo> data = conVariableRegisterParamHandler.findIncludeData(calculateDto, this.getVariableCode());
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(data)) {
            return resultMap;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (MainOnedaySalesDataVo dataVo : data) {
            if (Objects.nonNull(dataVo.getMinusSaleQuantity())) {
                total = total.add(dataVo.getMinusSaleQuantity());
            }
        }
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
