package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-23
 */
@Slf4j
@Service
public class MainStayPosSalesQuantityRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "mainStayPosSalesQuantity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "POS销售数（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空");
        Validate.notBlank(calculateDto.getActivityTypeCode(), "活动分类不能为空");
        Validate.notBlank(calculateDto.getActivityFormCode(), "活动形式不能为空");
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空");
//        Validate.notBlank(calculateDto.getStoresCode(), "门店编码不能为空");

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        AuditExecuteIndicatorDto dto = AuditExecuteIndicatorParamBuilder.buildMainParam(calculateDto, this.getVariableCode());
        //第一优先级-优先级最高的是按活动明细编码查找唯一指标值（一对一精准导入指标结果）；
        List<AuditExecuteIndicatorVo> resultList = auditExecuteIndicatorService.findListForVariable(dto);
        if (!CollectionUtils.isEmpty(resultList)) {
            resultMap.put(this.getVariableCode(), resultList.get(0).getIndicatorValue());
            return resultMap;
        }
        //其它-活动明细编码没填写的，就按活动申请时所有字段与执行指标表中字段匹配查找唯一值
        dto = AuditExecuteIndicatorParamBuilder.buildOtherParam(calculateDto, this.getVariableCode());
        dto.setActivityTypeCode(calculateDto.getActivityTypeCode());
        dto.setActivityFormCode(calculateDto.getActivityFormCode());
        dto.setProductCode(calculateDto.getProductCode());
        dto.setProductItemCode(calculateDto.getItemCode());
        dto.setProductCategoryCode(calculateDto.getCategoryCode());
        dto.setProductBrandCode(calculateDto.getBrandCode());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        dto.setSalesRegionCode(calculateDto.getSalesRegionCode());
        dto.setSalesOrgCode(calculateDto.getSalesGroupCode());
        resultList = auditExecuteIndicatorService.findListForVariable(dto);
        if (CollectionUtils.isEmpty(resultList)) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), resultList.get(0).getIndicatorValue());
        return resultMap;
    }
}
