package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-27
 */
@Service
@Slf4j
public class MarkProductDuringActTaskApprovedRateMilkRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private ConVariableDetailSdkService conVariableDetailSdkService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "markProductDuringActTaskApprovedRateMilk";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "指定产品活动期间任务达成率（含奶卡）（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 是否可配置
     *
     * @return 是否可配置
     */
    @Override
    public Boolean isConfigurable() {
        return true;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        MainOnedaySalesDataDto salesDataDto = new MainOnedaySalesDataDto();
        SalesGoalDto salesGoalDto = new SalesGoalDto();

        //参数
        salesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        if (!CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            salesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
            salesGoalDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        } else if (StringUtils.isNotEmpty(calculateDto.getSalesGroupCode())) {
            salesDataDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
            salesGoalDto.setSalesOrgProvinceCode(calculateDto.getSalesGroupCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getSalesRegionCode())) {
            salesDataDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
            salesGoalDto.setSalesOrgRegionCode(calculateDto.getSalesRegionCode());
        } else {
            throw new RuntimeException("客户编码、销售组、销售部门全部为空");
        }

        //包含产品
        List<ConVariableDetailVo> conVariableDetailVos = conVariableDetailSdkService.findConVariableList(calculateDto.getAuditFormulaCode(), this.getVariableCode());
        List<String> productCodes = conVariableDetailVos.stream().filter(e -> StringUtils.equals(ConItemTypeEnum.INCLUDE_GOODS.getCode(), e.getItemType())).map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productCodes)) {
            return resultMap;
        }

        salesDataDto.setProductCodes(productCodes);
        salesGoalDto.setIncludeProductCodeList(productCodes);

        if (!CollectionUtils.isEmpty(conVariableDetailVos)) {
            List<ConVariableDetailVo> filterList = conVariableDetailVos.stream().filter(e -> Objects.nonNull(e.getBeginTime()) && Objects.nonNull(e.getEndTime())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterList)) {
                ConVariableDetailVo variableDetailVo = conVariableDetailVos.get(0);
                salesDataDto.setStartTimeOrDate(DateUtil.format(variableDetailVo.getBeginTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                salesDataDto.setEndTimeOrDate(DateUtil.format(variableDetailVo.getEndTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
        }
        if (StringUtils.isEmpty(salesDataDto.getStartTimeOrDate()) && StringUtils.isEmpty(salesDataDto.getEndTimeOrDate())){
            Assert.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
            Assert.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
            salesDataDto.setStartTimeOrDate(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            salesDataDto.setEndTimeOrDate(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }

        Set<String> yearMonthLySet = new HashSet<>();
        yearMonthLySet.add(salesDataDto.getStartTimeOrDate().substring(0, 7));
        yearMonthLySet.add(salesDataDto.getEndTimeOrDate().substring(0, 7));
        salesGoalDto.setYearMonthLySet(yearMonthLySet);

        salesDataDto.setStartTimeOrDate(salesDataDto.getStartTimeOrDate().replaceAll("-", ""));
        salesDataDto.setEndTimeOrDate(salesDataDto.getEndTimeOrDate().replaceAll("-", ""));

        //主体日销售报表:调减后折后含税销额（含奶卡）
        List<MainOnedaySalesDataVo> salesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(salesDataDto);
        BigDecimal minusDiscountBehindTaxSaleAmountIn = salesDataVos.stream().filter(e -> Objects.nonNull(e.getMinusDiscountBehindTaxSaleAmountIn())).map(MainOnedaySalesDataVo::getMinusDiscountBehindTaxSaleAmountIn).reduce(BigDecimal.ZERO, BigDecimal::add);

        //销售任务:合同量的“折后任务额”
        salesGoalDto.setYearSalesTypeCode("contract");
        List<SalesGoalVo> salesGoalVos = salesGoalService.listForVariableCal(salesGoalDto);
        BigDecimal deliveryDiscountSalesAmount = salesGoalVos.stream().filter(e -> Objects.nonNull(e.getDeliveryDiscountSalesAmount())).map(SalesGoalVo::getDeliveryDiscountSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);

        if (BigDecimal.ZERO.compareTo(minusDiscountBehindTaxSaleAmountIn) == 0 || BigDecimal.ZERO.compareTo(deliveryDiscountSalesAmount) == 0) {
            return resultMap;
        }
        BigDecimal rate = minusDiscountBehindTaxSaleAmountIn.divide(deliveryDiscountSalesAmount, 8, RoundingMode.HALF_UP);
        resultMap.put(this.getVariableCode(), rate);
        return resultMap;
    }
}
