package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.CustomVariableSummaryDimensionEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-16
 */
@Service
@Slf4j
public class MaxActivityProductAllMonthSysReplayOrApplyNumberRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private ConVariableDetailSdkService conVariableDetailSdkService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "maxActivityProductAllMonthSysReplayOrApplyNumber";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "max（活动产品全月系统回复量件数，活动产品全月申请件数）（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public Boolean isConfigurable() {
        return true;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "活动细案明细编码不能为空！");
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
        Validate.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
        Validate.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");

        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        //活动产品全月申请件数
        //优先从执行指标表查询、其次按自定义条件汇总活动申请数据
        BigDecimal periodChPromoteQuantity = BigDecimal.ZERO;
        AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
        indicatorDto.setActiveNumber(calculateDto.getDetailPlanItemCode());
        List<AuditExecuteIndicatorVo> indicatorVoList = auditExecuteIndicatorService.findListForVariable(indicatorDto);
        if (!CollectionUtils.isEmpty(indicatorVoList)) {
            periodChPromoteQuantity = indicatorVoList.get(0).getIndicatorValue();
        } else {
            List<ConVariableDetailVo> variableDetailVos = conVariableDetailSdkService.findConVariableList(calculateDto.getAuditFormulaCode(), this.getVariableCode());
            variableDetailVos = variableDetailVos.stream().filter(e -> StringUtils.isNotEmpty(e.getSummaryDimension())).collect(Collectors.toList());
            Validate.notEmpty(variableDetailVos, "max（活动产品全月系统回复量件数，活动产品全月申请件数） 未配置汇总维度！");
            periodChPromoteQuantity = this.getPeriodChPromoteQuantity(variableDetailVos, calculateDto);
        }
        log.info("活动产品全月申请件数:{}", periodChPromoteQuantity);

        //活动产品全月系统回复量件数
        SalesPlanDto dto = new SalesPlanDto();
        dto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        dto.setYearMonthLyBegin(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH));
        dto.setYearMonthLyEnd(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH));
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setSalesProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
            dto.setProductBrandCode(calculateDto.getBrandCode());
        }
        List<SalesPlanVo> salesPlanVos = salesPlanService.findByConditions(dto);
        BigDecimal monthReturnQuantity = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(salesPlanVos)) {
            monthReturnQuantity = salesPlanVos.stream()
                    .filter(e -> Objects.nonNull(e.getRestoreQuantity()))
                    .map(SalesPlanVo::getRestoreQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        log.info("活动产品全月系统回复量件数:{}", monthReturnQuantity);

        if (Objects.isNull(periodChPromoteQuantity)) {
            periodChPromoteQuantity = BigDecimal.ZERO;
        }
        resultMap.put(this.getVariableCode(),
                periodChPromoteQuantity.compareTo(monthReturnQuantity) > 0 ? periodChPromoteQuantity : monthReturnQuantity);
        return resultMap;
    }

    private BigDecimal getPeriodChPromoteQuantity(List<ConVariableDetailVo> variableDetailVos, CalculateDto calculateDto) {
        String summaryDimension = variableDetailVos.get(0).getSummaryDimension();
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        if (StringUtils.equals(CustomVariableSummaryDimensionEnum.FIRST_CHANNEL_PRODUCT.getCode(), summaryDimension)) {
            Validate.notBlank(calculateDto.getFirstChannelCode(), "一级渠道编码不能为空！");
            dto.setFirstChannelCode(calculateDto.getFirstChannelCode());
        } else if (StringUtils.equals(CustomVariableSummaryDimensionEnum.SECOND_CHANNEL_PRODUCT.getCode(), summaryDimension)) {
            Validate.notBlank(calculateDto.getSecondChannelCode(), "二级渠道编码不能为空！");
            dto.setSecondChannelCode(calculateDto.getSecondChannelCode());
        } else if (StringUtils.equals(CustomVariableSummaryDimensionEnum.CUSTOMER_PRODUCT.getCode(), summaryDimension)) {
            Validate.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空！");
            dto.setCustomerCodes(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        } else {
            throw new RuntimeException("max（活动产品全月系统回复量件数，活动产品全月申请件数） 未知汇总维度[" + summaryDimension + "]！");
        }
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空！");

        List<String> activityFormCodeList = variableDetailVos.stream()
                .filter(e -> StringUtils.equals(ConItemTypeEnum.INCLUDE_ACTIVITY_FORM.getCode(), e.getItemType()) && StringUtils.isNotEmpty(e.getItemCode()))
                .map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        List<String> salesOrgCodeList = variableDetailVos.stream()
                .filter(e -> StringUtils.equals(ConItemTypeEnum.INCLUDE_SALES_ORG.getCode(), e.getItemType()) && StringUtils.isNotEmpty(e.getItemCode()))
                .map(ConVariableDetailVo::getItemCode).distinct().collect(Collectors.toList());
        Validate.notEmpty(activityFormCodeList, "max（活动产品全月系统回复量件数，活动产品全月申请件数）可选活动形式为空！");
        Validate.notEmpty(salesOrgCodeList, "max（活动产品全月系统回复量件数，活动产品全月申请件数）可选销售组织为空！");
        List<SalesOrgVo> allSalesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCodes(salesOrgCodeList);
        Validate.notEmpty(allSalesOrgVos, "max（活动产品全月系统回复量件数，活动产品全月申请件数）可选销售组织不存在！");
        salesOrgCodeList = allSalesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).distinct().collect(Collectors.toList());

        dto.setIncludeProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        dto.setIncludeActivityFormCodeList(activityFormCodeList);
        dto.setIncludeActivityOrgCodeList(salesOrgCodeList);
        dto.setFeeYearMonthStrBegin(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH) + "-01 00:00:00");
        dto.setFeeYearMonthStrEnd(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH) + "-01 00:00:00");

        List<ActivityDetailPlanItemVo> vos = activityDetailPlanItemSdkService.listForVariable(dto);
        if (CollectionUtils.isEmpty(vos)) {
            return BigDecimal.ZERO;
        }
        return vos.stream()
                .filter(e -> Objects.nonNull(e.getPeriodChPromoteQuantity()))
                .map(ActivityDetailPlanItemVo::getPeriodChPromoteQuantity)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}
