package com.biz.crm.tpm.business.variable.local.register.mainstay;

import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 试销期合并计算（月）
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-16
 */
@Service
@Slf4j
public class TrialSalesPeriodSummaryMonthRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private CustomerVoService customerVoService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "trialSalesPeriodSummaryMonth";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "试销期合并计算（月）（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码为空！");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间为空！");
        List<CustomerVo> customerVos = customerVoService.findByErpCodeList(Lists.newArrayList(calculateDto.getCustomerErpCode()));
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(customerVos)) {
            return resultMap;
        }
        customerVos = customerVos.stream().filter(e-> Objects.nonNull(e.getCreateTime())).sorted(Comparator.comparing(CustomerVo::getCreateTime)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerVos)) {
            return resultMap;
        }
        Date createTime = customerVos.get(0).getCreateTime();
        int result = 0;
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(DateUtil.date_yyyy_MM_dd.parse(DateUtil.format(createTime, DateUtil.DEFAULT_YEAR_MONTH_DAY)));
            c2.setTime(DateUtil.date_yyyy_MM_dd.parse(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY)));
            result = (c1.get(Calendar.YEAR) - c2.get(Calendar.YEAR)) * 12 + c1.get(Calendar.MONTH) - c2.get(Calendar.MONTH);
        } catch (Exception var7) {
            log.error("试销期（月），日期处理异常", var7);
            throw new RuntimeException("试销期（月），日期处理异常：" + var7.getMessage());
        }
        resultMap.put(this.getVariableCode(), new BigDecimal(result == 0 ? 1 : Math.abs(result)));
        return resultMap;
    }
}
