package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MoleculeDateProductionRegister
 * @description: 生产日期-分子
 * @date: 2023/2/21 15:43.
 * @author: hb
 */

@Service
@Slf4j
public class MoleculeDateProductionRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "moleculeDateProduct";
    }

    @Override
    public String getVariableName() {
        return "生产日期（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");

        List<TpmInventoryCheckVo> list = super.findInventoryCheck(calculateDto, "");

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        return resultMap;
    }
}
