package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MoleculeDayAgeRegister
 * @description: 日龄分仓
 * @date: 2023/2/21 15:41.
 * @author: hb
 */
@Service
@Slf4j
public class MoleculeDayAgeRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {

    private static final String INVENTORY_TYPE = "BRANCH_WAREHOUSE_INVENTORY";

    @Override
    public String getVariableCode() {
        return "moleculeDayAge";
    }

    @Override
    public String getVariableName() {
        return "日龄-分仓（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        BigDecimal months = super.getMonthDay(calculateDto, INVENTORY_TYPE, false);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), months);

        return resultMap;
    }
}
