package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MoleculeFirstDisplayAchievementRateRegister
 * @description: 第一陈列达成率(分子)
 * @author: hb
 * @create: 2023-03-13 11:15
 */
@Slf4j
@Service
public class MoleculeFirstDisplayAchievementRateRegister implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "firstDisplayAchievementRate";
    }

    @Override
    public String getVariableName() {
        return "第一陈列达成率（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        return resultMap;
    }
}
