package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MoleculeMonthProductionRegister
 * @description: 生产月份-分子
 * @date: 2023/2/21 15:45.
 * @author: hb
 */
@Service
@Slf4j
public class MoleculeMonthProductionRegister implements FormulaVariableRegister {


    @Override
    public String getVariableCode() {
        return "moleculeMonthProduction";
    }

    @Override
    public String getVariableName() {
        return "生产月份（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        return resultMap;
    }
}
