package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.inventory.check.manage.sdk.constant.TpmInventoryCheckConstant;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @className: MoleculeNumberProductRegister
 * @description: 产品数量-分仓
 * @date: 2023/2/21 15:48.
 * @author: hb
 */
@Service
@Slf4j
public class MoleculeNumberProductBranchWarehouseRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {
    @Override
    public String getVariableCode() {
        return "moleculeNumberProductBranchWarehouse";
    }

    @Override
    public String getVariableName() {
        return "产品数量-分仓（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

//    @Override
//    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");
//        Validate.notNull(calculateDto.getDate(), "调用日期不能为空");
//        Validate.notNull(calculateDto.getBusinessFormatCode(), "业态编码不能为空");
//        Validate.notNull(calculateDto.getBusinessUnitCode(), "业务单元编码不能为空");
//        Validate.notNull(calculateDto.getSalesGroupCode(),"销售组织编码不能为空");
//        List<TpmInventoryCheckVo> tpmInventoryCheckVos = super.findInventoryCheck(calculateDto,"BRANCH_WAREHOUSE_INVENTORY");
//        Map<String, BigDecimal> resultMap = Maps.newHashMap();
//        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
//        if(!CollectionUtils.isEmpty(tpmInventoryCheckVos)){
//            Integer sum = tpmInventoryCheckVos.stream().mapToInt(TpmInventoryCheckVo::getQuantity).sum();
//            resultMap.put(this.getVariableCode(), new BigDecimal(sum));
//        }
//        return resultMap;
//    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculateDto.getDate(), "调用日期不能为空");
        Validate.notNull(calculateDto.getBusinessFormatCode(), "业态编码不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(), "业务单元编码不能为空");
        Validate.notNull(calculateDto.getSalesGroupCode(), "销售组织编码不能为空");
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), super.getQuantity(calculateDto.getInventoryCheckVo(), TpmInventoryCheckConstant.BRANCH_WAREHOUSE_INVENTORY));
        return resultMap;
    }
}
