package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.inventory.check.manage.sdk.constant.TpmInventoryCheckConstant;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 产品数量-门店
 */
@Service
@Slf4j
public class MoleculeNumberProductStoreRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {
    @Override
    public String getVariableCode() {
        return "moleculeNumberProductStore";
    }

    @Override
    public String getVariableName() {
        return "产品数量-门店（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

//    @Override
//    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空");
//        Validate.notNull(calculateDto.getDate(), "调用日期不能为空");
//        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态编码不能为空");
//        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元编码不能为空");
//        Validate.notBlank(calculateDto.getSalesGroupCode(),"销售组织编码不能为空");
//        Validate.notBlank(calculateDto.getStoresCode(),"门店编码不能为空");
//        List<TpmInventoryCheckVo> tpmInventoryCheckVos = super.findInventoryCheck(calculateDto,"TERMINAL_INVENTORY");
//        int sum = 0;
//        if(!CollectionUtils.isEmpty(tpmInventoryCheckVos)){
//            sum = tpmInventoryCheckVos.get(0).getQuantity();
//        }
//        Map<String, BigDecimal> resultMap = Maps.newHashMap();
//        resultMap.put(this.getVariableCode(), new BigDecimal(sum));
//        return resultMap;
//    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculateDto.getDate(), "调用日期不能为空");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态编码不能为空");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元编码不能为空");
        Validate.notBlank(calculateDto.getSalesGroupCode(), "销售组织编码不能为空");
        Validate.notBlank(calculateDto.getStoresCode(), "门店编码不能为空");
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), super.getQuantity(calculateDto.getInventoryCheckVo(), TpmInventoryCheckConstant.TERMINAL_INVENTORY));
        return resultMap;
    }

}
