package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MoleculeNumberWarehouseStaffRegister
 * @description: 店仓业务员数量（分子）
 * @author: hb
 * @create: 2023-03-13 10:48
 */
@Service
public class MoleculeNumberWarehouseStaffRegister implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "numberWarehouseStaff";
    }

    @Override
    public String getVariableName() {
        return "店仓业务员数量（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        return resultMap;
    }
}
