package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @className: MoleculeSapAfterWholeProductOneToTenRegister
 * @description: SAP出库额-折后_全品_1至10日（分子）
 * @author: hb
 * @create: 2023-03-13 10:37
 */
@Service
public class MoleculeSapAfterWholeProductOneToTenRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    @Override
    public String getVariableCode() {
        return "sapAfterWholeProductOneToTen";
    }

    @Override
    public String getVariableName() {
        return "SAP出库额-折后_全品_1至10日（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空！");
        TpmSapDaySalesDto daySalesDto = SapDeliveryRegisterParamBuilder.buildParam(calculateDto);
        daySalesDto.setActivityBeginTime(calculateDto.getYearMonthLy().replaceAll("-", "") + "01");
        daySalesDto.setActivityEndTime(calculateDto.getYearMonthLy().replaceAll("-", "") + "10");
        daySalesDto.setProductCodes(null);
        daySalesDto.setBrandList(null);
        daySalesDto.setCategoryCodeList(null);
        daySalesDto.setItemCodes(null);

        List<TpmSapDaySalesVo> daySalesVos = tpmSapDaySalesService.listForVariable(daySalesDto);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(daySalesVos)) {
            return resultMap;
        }
        BigDecimal total = daySalesVos.stream()
                .filter(e -> Objects.nonNull(e.getInvoiceAmt()))
                .map(TpmSapDaySalesVo::getInvoiceAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
