package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * SAP出库数量
 */
@Service
@Slf4j
public class MoleculeSapOutNumberRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmSapDaySalesService tpmSapDaySalesService;
    @Override
    public String getVariableCode() {
        return "moleculeSapOutNumber";
    }

    @Override
    public String getVariableName() {
        return "SAP出库数量（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getStartTimeOrDate(), "开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "结束时间不能为空");
        TpmSapDaySalesDto dto = SapDeliveryRegisterParamBuilder.buildParam(calculateDto);
        dto.setActivityBeginTime(DateUtil.format(calculateDto.getStartTimeOrDate(),"yyyyMMdd" ));
        dto.setActivityEndTime(DateUtil.format(calculateDto.getEndTimeOrDate(),"yyyyMMdd"));
        List<TpmSapDaySalesVo> sapDaySalesVos = tpmSapDaySalesService.listForVariable(dto);

        BigDecimal deliveryOrderNum = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(sapDaySalesVos)){
            for (TpmSapDaySalesVo vo : sapDaySalesVos){
                deliveryOrderNum = deliveryOrderNum.add(new BigDecimal(vo.getDeliveryOrderNum()));
            }
        }
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), deliveryOrderNum);
        return resultMap;
    }
}
