package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.inventory.check.manage.sdk.constant.TpmInventoryCheckConstant;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MoleculeShelfLifeRegister
 * @description:
 * @date: 2023/2/21 15:54.
 * @author: hb
 */
@Service
@Slf4j
public class MoleculeShelfLifeRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "moleculeShelfLife";
    }

    @Override
    public String getVariableName() {
        return "保质期（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.LARGEDATE);
        return list;
    }

//    @Override
//    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");
//        Validate.notNull(calculateDto.getDate(), "调用日期不能为空");
//        Validate.notNull(calculateDto.getBusinessFormatCode(), "业态编码不能为空");
//        Validate.notNull(calculateDto.getBusinessUnitCode(), "业务单元编码不能为空");
//        Validate.notNull(calculateDto.getSalesGroupCode(),"销售组织编码不能为空");
//
//        List<TpmInventoryCheckVo> list = super.findInventoryCheck(calculateDto,"");
//        BigDecimal expirationDate = BigDecimal.ZERO;
//        if(CollectionUtils.isNotEmpty(list)){
//            expirationDate = new BigDecimal(list.get(0).getExpirationDate());
//        }
//        Map<String, BigDecimal> resultMap = Maps.newHashMap();
//        resultMap.put(this.getVariableCode(), expirationDate);
//        return resultMap;
//    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculateDto.getDate(), "调用日期不能为空");
        Validate.notNull(calculateDto.getBusinessFormatCode(), "业态编码不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(), "业务单元编码不能为空");
        Validate.notNull(calculateDto.getSalesGroupCode(), "销售组织编码不能为空");
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), super.getExpireDate(calculateDto.getInventoryCheckVo(), null));
        return resultMap;
    }
}
