package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: MonthAgeTerminalRegister
 * @description: 月龄-门店
 * @author: hb
 * @create: 2023-02-26 11:36
 */

@Service
public class MonthAgeTerminalRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {

    private static final String INVENTORY_TYPE =  "TERMINAL_INVENTORY";

    @Override
    public String getVariableCode() {
        return "monthAagTerminal";
    }

    @Override
    public String getVariableName() {
        return "月龄-门店（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);

        return null;

    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        this.moleculeValidate(calculateDto);

        BigDecimal months = this.getMonthDay(calculateDto, INVENTORY_TYPE,true);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), months);

        return resultMap;
    }

    private void moleculeValidate(CalculateDto calculate){

        Validate.notNull(calculate.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculate.getSalesOrgCode(), "销售组织编码不能为空");
        Validate.notNull(calculate.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculate.getBusinessFormatCode(), "业态不能为空");
        Validate.notNull(calculate.getDate(), "调用日期不能为空");

    }
}
