package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.local.register.common.PriceRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * @className: StandardSupplyPriceRegister
 * @description: 标准供货价
 * @author: hb
 * @create: 2023-02-28 19:53
 */
@Slf4j
@Service
public class StandardSupplyPriceRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;


    @Override
    public String getVariableCode() {
        return "standardSupplyPrice";
    }

    @Override
    public String getVariableName() {
        return "标准供货价（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();

        list.add(VariableFunctionEnum.WITHHOLDING);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getStoresCode(), "门店编码为空！");
        SearchPriceDto searchPrice = PriceRegisterParamBuilder.buildParam(calculateDto, PriceTypeEnum.ZP01);
        Map<String, PriceModelVo> priceModelVoMap = priceModelVoService.handleSearchPrice(searchPrice);
        BigDecimal resultPrice = BigDecimal.ZERO;
        if (Objects.nonNull(priceModelVoMap)) {
            for (Map.Entry<String, PriceModelVo> entry : priceModelVoMap.entrySet()) {
                PriceModelVo value = entry.getValue();
                BigDecimal price = value.getPrice();
                if (!Objects.isNull(price)) {
                    resultPrice = price;
                    break;
                }
            }
        }
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), resultPrice);
        return resultMap;
    }
}
