package com.biz.crm.tpm.business.variable.local.register.molecule;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: StrengthRegister
 * @description: 力度(分子)
 * @author: hb
 * @create: 2023-03-01 11:08
 */

@Service
public class StrengthRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;


    @Override
    public String getVariableCode() {
        return "strength";
    }

    @Override
    public String getVariableName() {
        return "力度（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();

        list.add(VariableFunctionEnum.AUDIT);

        return list;

    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        Validate.notNull(calculateDto.getDetailPlanItemCode(), "分子活动细案明细编码不能为空");

        List<String> list = Lists.newArrayList();
        list.add(calculateDto.getDetailPlanItemCode());

        List<SubComActivityDetailPlanItemVo> resultList = subComActivityDetailPlanItemVoService.findDetailByItemCodeList(list);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        if (CollectionUtils.isEmpty(resultList) || resultList.size() == 0){
            return resultMap;
        }

        SubComActivityDetailPlanItemVo subComActivityDetailPlanItemVo = resultList.get(0);
        BigDecimal originalProductPrice = subComActivityDetailPlanItemVo.getOriginalProductPrice();
        BigDecimal activityPrice = subComActivityDetailPlanItemVo.getActivityPrice();
        BigDecimal lastPrice = originalProductPrice.subtract(activityPrice);

        resultMap.put(this.getVariableCode(), lastPrice);

        return resultMap;

    }
}
