package com.biz.crm.tpm.business.variable.local.register.salesgoal;

import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-07
 */
@Slf4j
@Service
public class ActivityProductAllMonthReplyQuantityRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "activityProductAllMonthReplyQuantity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "活动产品全月回复量件数（主体）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
        Validate.notNull(calculateDto.getCustomerCode(), "客户编码不能为空");

        SalesPlanDto dto = new SalesPlanDto();
        dto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setSalesProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
            dto.setProductBrandCode(calculateDto.getBrandCode());
        }
        List<SalesPlanVo> salesPlanVos = salesPlanService.findByConditions(dto);
        Map<String, BigDecimal> resultMap = new HashMap<>();
        if (CollectionUtils.isEmpty(salesPlanVos)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(),
                salesPlanVos.stream()
                        .filter(e -> Objects.nonNull(e.getRestoreQuantity()))
                        .map(SalesPlanVo::getRestoreQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        return resultMap;
    }
}
