package com.biz.crm.tpm.business.variable.local.register.salesgoal;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/14 11:11
 * @description：全月全品折后任务量
 */
@Service
@Slf4j
public class AllMonthAllProductDiscountTaskRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Override
    public String getVariableCode() {
        return "AllMonthAllProductDiscountTaskNumber";
    }

    @Override
    public String getVariableName() {
        return "全月全品折后任务量（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        //全月全品折后任务量：销售任务管理（年月+销售组织+客户+全品）

//        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
//        Validate.notNull(calculateDto.getSalesOrgCode(), "销售组织编码不能为空");
//        Validate.notNull(calculateDto.getCustomerCode(), "客户编码不能为空");

        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(calculateDto.getSalesOrgCode()) || StringUtils.isNotEmpty(calculateDto.getCustomerCode()),
                "[全月全品折后任务量] 销售组织编码和客户编码不能同时为空！");

        SalesGoalDto salesGoalDto = new SalesGoalDto();
        if (CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            salesGoalDto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        }
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        salesGoalDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        List<SalesGoalVo> salesGoalVos = salesGoalService.listForVariableCal(salesGoalDto);
        if (CollectionUtils.isEmpty(salesGoalVos)) {
            HashMap<String, BigDecimal> resultMap = new HashMap<>();
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }

        //获取类型为合同的
        salesGoalVos = salesGoalVos
                .stream()
                .filter(salesGoalVo -> salesGoalVo.getYearSalesTypeCode().equals("contract"))
                .collect(Collectors.toList());

        HashMap<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode()
                , salesGoalVos.stream()
                        .map(SalesGoalVo::getTaskQuantity)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        return resultMap;
    }
}
