package com.biz.crm.tpm.business.variable.local.register.salesgoal;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @className: AllMonthProductDiscountTaskAmountRegister
 * @description: 全月全品折后任务额
 * @author: hb
 * @create: 2023-02-22 11:39
 */
@Slf4j
@Service
public class AllMonthProductDiscountTaskAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Override
    public String getVariableCode() {
        return "AllMonthProductDiscountTaskAmount";
    }

    @Override
    public String getVariableName() {
        return "全月全品折后任务额（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

//        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
//        Validate.notNull(calculateDto.getSalesOrgCode(), "销售组织编码不能为空");
//        Validate.notNull(calculateDto.getCustomerCode(), "客户编码不能为空");

        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(calculateDto.getSalesOrgCode()) || StringUtils.isNotEmpty(calculateDto.getCustomerCode()),
                "[全月全品折后任务量] 销售组织编码和客户编码不能同时为空！");

        SalesGoalDto salesGoalDto = new SalesGoalDto();
        if (CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            salesGoalDto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        }
        salesGoalDto.setYearMonthLy(calculateDto.getYearMonthLy());
        salesGoalDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        List<SalesGoalVo> salesGoalVos = salesGoalService.listForVariableCal(salesGoalDto);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        if (CollectionUtils.isEmpty(salesGoalVos)) {
            return resultMap;
        }

        //获取类型为合同的
        salesGoalVos = salesGoalVos
                .stream()
                .filter(salesGoalVo -> salesGoalVo.getYearSalesTypeCode().equals("contract"))
                .collect(Collectors.toList());

        resultMap.put(this.getVariableCode()
                , salesGoalVos
                        .stream()
                        .map(SalesGoalVo::getDeliveryDiscountSalesAmount)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal::add)
                        .orElse(BigDecimal.ZERO));
        return resultMap;
    }
}
