package com.biz.crm.tpm.business.variable.local.register.salesgoal;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/26 17:26
 * @description：任务量
 */
@Service
@Slf4j
public class TaskAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    /**
     * 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public String getVariableCode() {
        return "taskAmount";
    }

    @Override
    public String getVariableName() {
        return "任务量";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空");
        Validate.notBlank(calculateDto.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculateDto.getDate(), "日期不能为空");
        // 1）从数据中台取值；2）数据回传数据存在销售任务主表里，取实时回传数据内客户+产品+活动时间的销售（基本计算量）
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setCustomerCode(calculateDto.getCustomerCode());
        salesGoalDto.setProductCode(calculateDto.getProductCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        salesGoalDto.setYearMonthLy(sdf.format(calculateDto.getDate()).substring(0, 7));
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), salesGoalService.getTaskAmount(salesGoalDto));
        return resultMap;
    }
}
