package com.biz.crm.tpm.business.variable.local.register.settlement;

import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.enums.TpmSettlementActivityFormEnum;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ：duyiran
 * @date ：Created in 2022/11/26 17:22
 * @description：渠道推广
 */
@Service
@Slf4j
public class ChannelPromotionRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmSettlementManageService tpmSettlementManageService;

    /**
     * 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.WITHHOLDING);
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.WARNING);
        return functionList;
    }

    @Override
    public String getVariableCode() {
        return "channelPromotion";
    }

    @Override
    public String getVariableName() {
        return "渠道推广（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空");
        Validate.notBlank(calculateDto.getYearMonthLy(), "活动年月不能为空");
        TpmSettlementManageDto dto = new TpmSettlementManageDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setProductCode(calculateDto.getProductCode());
        dto.setYearMonthStr(calculateDto.getYearMonthLy());
        TpmSettlementActivityFormEnum activityFormEnum = TpmSettlementActivityFormEnum.findByCode(this.getVariableCode());
        Validate.notNull(activityFormEnum, "不支持的变量");
        dto.setActivityFormCode(activityFormEnum.getDesc());
        HashMap<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode(), tpmSettlementManageService.getAmountByActivityFormCode(dto));
        return resultMap;
    }

}
