package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComSalesPlanParamBuilder;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @className: AmountDeliveredAfterConversionRegister
 * @description: 月度销售计划折后出库额
 * @date: 2023/2/19 13:52.
 * @author: hb
 */
@Service
@Slf4j
public class AmountDeliveredAfterConversionRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Override
    public String getVariableCode() {
        return "monthAmountDeliveredAfterConversion";
    }

    @Override
    public String getVariableName() {
        return "月度销售计划折后出库额（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        //参数验证
//        salesParamsValidate(calculateDto);
//        //参数赋值
//        SalesPlanDto salesPlan = salesParamsAssignment(calculateDto);
        List<SalesPlanDto> paramList = SubComSalesPlanParamBuilder.buildOtherParamList(calculateDto);
        SalesPlanDto customerDto = paramList.get(0);
        SalesPlanDto terminalDto = paramList.get(1);
        //取值
        List<SalesPlanVo> list = this.salesPlanService.findByConditions(customerDto);
        if (CollectionUtils.isEmpty(list) && Objects.nonNull(terminalDto)) {
            list = this.salesPlanService.findByConditions(terminalDto);
        }

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(list)){
            return resultMap;
        }
        BigDecimal discountedIncomeTotal = list.stream().map(SalesPlanVo::getDiscountedIncome)
                .collect(Collectors.toList())
                .stream()
                .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);
        resultMap.put(this.getVariableCode(), discountedIncomeTotal);

        return resultMap;
    }

    /**
     * 参数赋值
     * @param calculateDto 传入参数
     * @return salesPlan
     */
    private SalesPlanDto salesParamsAssignment(CalculateDto calculateDto){
        SalesPlanDto salesPlan = new SalesPlanDto();
        salesPlan.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesPlan.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesPlan.setErpCode(calculateDto.getCustomerErpCode());
        salesPlan.setYearMonthLy(calculateDto.getYearMonthLy());
//        salesPlan.setSalesOrgCode(calculateDto.getSalesOrgCode());//20230506取消组织过滤
        salesPlan.setProductCode(calculateDto.getProductCode());
        return salesPlan;
    }

    /**
     * 参数验证
     * @param calculateDto 待验证参数
     */
    private void salesParamsValidate(CalculateDto calculateDto){
        Validate.notNull(calculateDto.getCustomerErpCode(),"客户MDG编码不能为空");
//        Validate.notNull(calculateDto.getSalesOrgCode(), "销售组织不能为空");
        Validate.notNull(calculateDto.getYearMonthLy(),"年月不能为空");
        Validate.notNull(calculateDto.getBusinessFormatCode(),"业态不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(),"业务单元不能为空");
    }
}
