package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ExecutedQuantityRegister
 * @description: 事中促销活动已执行量
 * @date: 2023/2/19 17:02.
 * @author: hb
 */
@Service
@Slf4j
public class ExecutedQuantityRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public String getVariableCode() {
        return "executedQuantity";
    }

    @Override
    public String getVariableName() {
        return "事中促销活动已执行量（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getDetailPlanItemCode(), "分子活动细案活动明细编码不能为空");

        List<AuditExecuteIndicatorVo> list = this.auditExecuteIndicatorService
                .findByCode(calculateDto.getDetailPlanItemCode()
                        , QueryConstant.INDICATOR_NAME_SAP_OCCURRENCE_QUANTITY);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(list)){
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), list.get(0).getIndicatorValue());

        return resultMap;
    }
}
