package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComSalesPlanParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author huangbo
 * @data 2023-2-18
 * @description 月度销售计划
 */
@Service
@Slf4j
public class PlannedMonthlySalesVolumeRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Override
    public String getVariableCode() {
        return "plannedMonthlySalesVolume";
    }

    @Override
    public String getVariableName() {
        return "月度销售计划（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionEnumList = Lists.newArrayList();
        functionEnumList.add(VariableFunctionEnum.AUDIT);
        return functionEnumList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        //参数验证
//        salesParamsValidate(calculateDto);
//        //参数赋值
//        SalesPlanDto salesPlan = salesParamsAssignment(calculateDto);
        //查询
        List<SalesPlanDto> paramList = SubComSalesPlanParamBuilder.buildOtherParamList(calculateDto);
        SalesPlanDto customerDto = this.setOtherParam(paramList.get(0), calculateDto);
        SalesPlanDto terminalDto = this.setOtherParam(paramList.get(1), calculateDto);
        List<SalesPlanVo> list = this.salesPlanService.findByConditions(customerDto);
        if (CollectionUtils.isEmpty(list) && Objects.nonNull(terminalDto)) {
            list = this.salesPlanService.findByConditions(terminalDto);
        }
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(list)){
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), list.get(0).getPlanQuantity());

        return resultMap;
    }

    /**
     * 参数赋值
     * @param calculateDto 传入参数
     * @return salesPlan
     */
    private SalesPlanDto salesParamsAssignment(CalculateDto calculateDto){
        SalesPlanDto salesPlan = new SalesPlanDto();
        salesPlan.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesPlan.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesPlan.setErpCode(calculateDto.getCustomerErpCode());
        salesPlan.setYearMonthLy(calculateDto.getYearMonthLy());
        salesPlan.setSalesOrgCode(calculateDto.getSalesOrgCode());
        salesPlan.setProductCode(calculateDto.getProductCode());
        return salesPlan;
    }

    /**
     * 参数验证
     * @param calculateDto 待验证参数
     */
    private void salesParamsValidate(CalculateDto calculateDto){
        Validate.notNull(calculateDto.getCustomerErpCode(),"客户MDG编码不能为空");
        Validate.notNull(calculateDto.getSalesOrgCode(), "销售组织不能为空");
        Validate.notNull(calculateDto.getYearMonthLy(),"年月不能为空");
        Validate.notNull(calculateDto.getBusinessFormatCode(),"业态不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(),"业务单元不能为空");
    }

    private SalesPlanDto setOtherParam(SalesPlanDto salesPlan, CalculateDto calculateDto) {
        if (Objects.isNull(salesPlan)) {
            return null;
        }
        Validate.notNull(calculateDto.getSalesOrgCode(), "销售组织不能为空");
        salesPlan.setSalesOrgCode(calculateDto.getSalesOrgCode());
        return salesPlan;
    }
}
