package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import liquibase.pro.packaged.B;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @className: PosAmountRegister
 * @description: Pos 金额
 * @date: 2023/2/19 14:10.
 * @author: hb
 */
@Service
@Slf4j
public class PosAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private InvoiceSalesDataVoService salesDataVoService;

    @Override
    public String getVariableCode() {
        return "posAmount";
    }

    @Override
    public String getVariableName() {
        return "Pos金额（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        saleDataValidate(calculateDto);
        //赋值
        QueryConditionDto queryCondition = new QueryConditionDto();
        salesDataAssignment(queryCondition, calculateDto);

        SalesDataVo salesDataVo = salesDataVoService.findByCondition(queryCondition);
        Map<String,BigDecimal> resultMap = new HashMap<>(1);
        if(ObjectUtils.isEmpty(salesDataVo) || ObjectUtils.isEmpty(salesDataVo.getSalesAmount())){
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesDataVo.getSalesAmount());

        return resultMap;
    }

    private void saleDataValidate(CalculateDto calculateDto){
        Validate.notNull(calculateDto.getStartTimeOrDate(), "开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "结束时间不能为空");
        Validate.notNull(calculateDto.getProductCode(), "产品不能为空");
        Validate.notNull(calculateDto.getStoresCode(), "门店不能为空");
    }

    private void salesDataAssignment(QueryConditionDto queryCondition, CalculateDto calculateDto){
        String startTimeOrDateFormat = DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String endTimeOrDateFormat = DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        queryCondition.setStartTimeOrDate(startTimeOrDateFormat);
        queryCondition.setEndTimeOrDate(endTimeOrDateFormat);
        queryCondition.setGoodsCode(calculateDto.getProductCode());
        queryCondition.setDeliveryPartyCode(calculateDto.getStoresCode());
    }
}
