package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.local.register.common.VariableProductLevelService;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SapDeliveryRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComVariableSearchCommonService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-17
 */
@Service
@Slf4j
public class SapPartProductDiscountDeliveryQuantityRegister extends SubComVariableSearchCommonService implements FormulaVariableRegister {

    @Autowired(required = false)
    private VariableProductLevelService variableProductLevelService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "sapPartProductDiscountDeliveryQuantity";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "SAP出库数量-小品项（分子）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空！");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空！");
        ProductLevelVo vo = new ProductLevelVo();
        vo.setLevelLabel(VariableCommonConstants.levelLabel_1);
        Map<String, List<String>> map = variableProductLevelService.levelCodeMap(vo);
        List<TpmSapDaySalesDto> paramList = SapDeliveryRegisterParamBuilder.buildParamList(calculateDto);
        TpmSapDaySalesDto customerDto = this.buildParam(paramList.get(0), calculateDto, map);
        TpmSapDaySalesDto terminalDto = this.buildParam(paramList.get(1), calculateDto, map);
        List<TpmSapDaySalesVo> daySalesVos = super.tpmSapDaySalesVoList1(customerDto, terminalDto);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(daySalesVos)) {
            return resultMap;
        }
        BigDecimal total = daySalesVos.stream()
                .filter(e -> Objects.nonNull(e.getDeliveryOrderNum()))
                .map(e -> {
                    BigDecimal val = BigDecimal.ZERO;
                    try {
                        val = new BigDecimal(e.getDeliveryOrderNum());
                    } catch (Exception ex) {
                        log.error("变量 ===》 [SAP出库数量-小品项（分子）] ===》 [" + e.getDeliveryOrderNum() + "]计算异常：" + ex.getMessage());
                    }
                    return val;
                })
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }

    private TpmSapDaySalesDto buildParam(TpmSapDaySalesDto daySalesDto, CalculateDto calculateDto, Map<String, List<String>> map) {
        if (Objects.nonNull(daySalesDto)) {
            daySalesDto.setActivityBeginTime(DateUtil.format(calculateDto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY).replaceAll("-", ""));
            daySalesDto.setActivityEndTime(DateUtil.format(calculateDto.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY).replaceAll("-", ""));
            //查询品项表中打了小品项标签的品项数据
            daySalesDto.setProductCodes(null);
            daySalesDto.setBrandList(map.get(ProductLevelEnum.brand.getCode()));
            daySalesDto.setCategoryCodeList(map.get(ProductLevelEnum.category.getCode()));
            daySalesDto.setItemCodes(map.get(ProductLevelEnum.items.getCode()));
        }
        return daySalesDto;
    }
}
