package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-05-12
 */
@Service
@Slf4j
public class SubComActivityDetailApplyAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Override
    public String getVariableCode() {
        return "subComActivityDetailApplyAmount";
    }

    @Override
    public String getVariableName() {
        return "分子活动细案申请金额（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.WITHHOLDING);
        functionList.add(VariableFunctionEnum.WARNING);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notEmpty(calculateDto.getDetailPlanItemCode(), "细案明细编码为空！");
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        List<SubComActivityDetailPlanItemVo> vos = subComActivityDetailPlanItemVoService.findDetailByPlanItemCode(calculateDto.getDetailPlanItemCode());
        if (CollectionUtils.isEmpty(vos)) {
            return resultMap;
        }
        BigDecimal totalCost = vos.get(0).getTotalCost();
        if (Objects.isNull(totalCost)) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), totalCost);
        return resultMap;
    }
}
