package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubComAuditExecutorIndicatorVariableService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-10
 */
@Service
@Slf4j
public class SubComStoreSalesmenQuantityRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private SubComAuditExecutorIndicatorVariableService subComAuditExecutorIndicatorVariableService;

    @Override
    public String getVariableCode() {
        return "subComStoreSalesmenQuantity";
    }

    @Override
    public String getVariableName() {
        return "店仓业务员数量（分子）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        subComAuditExecutorIndicatorVariableService.valActivityNumber(calculateDto);
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(),subComAuditExecutorIndicatorVariableService.calActivityNumber(calculateDto));
        return resultMap;
    }
}
