package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-20
 */
@Service
@Slf4j
public class SubCompanyApprovedAmountRegister implements FormulaVariableRegister {

    @Autowired
    private SubComActivityDetailPlanItemVoService activityConstituentDetailPlanItemVoService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "subCompanyApprovedAmount";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "批复额（分子）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "活动细案明细编码不能为空！");
        List<SubComActivityDetailPlanItemVo> planItemVos = activityConstituentDetailPlanItemVoService.findItemsByPlanItemCodes(Lists.newArrayList(calculateDto.getDetailPlanItemCode()));
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(planItemVos)) {
            return resultMap;
        }
        SubComActivityDetailPlanItemVo planItemVo = planItemVos.get(0);
        BigDecimal headquartersSupportedAmount = Objects.nonNull(planItemVo.getHeadquartersSupportedAmount()) ? planItemVo.getHeadquartersSupportedAmount() : BigDecimal.ZERO;
        BigDecimal subComAutoAmount = Objects.nonNull(planItemVo.getSubComAutoAmount()) ? planItemVo.getSubComAutoAmount() : BigDecimal.ZERO;
        resultMap.put(this.getVariableCode(), headquartersSupportedAmount.add(subComAutoAmount));
        return resultMap;
    }
}
