package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.SubComAuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-20
 */
@Service
@Slf4j
public class SubCompanyOriginalContractTargetAmountRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "subCompanyOriginalContractTargetAmount";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "原合同目标金额（分子）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元不能为空！");
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空！");
        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构编码不能为空！");
        Validate.notBlank(calculateDto.getDistributionChannel(), "分销渠道不能为空！");
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空！");

        List<AuditExecuteIndicatorDto> paramList = SubComAuditExecuteIndicatorParamBuilder.buildSubComParamList(calculateDto, this.getVariableCode());
        AuditExecuteIndicatorDto customerDto = this.buildParam(paramList.get(0), calculateDto);
        AuditExecuteIndicatorDto terminalDto = this.buildParam(paramList.get(1), calculateDto);
        List<AuditExecuteIndicatorVo> vos = auditExecuteIndicatorService.findListForVariable(customerDto);
        if (CollectionUtils.isEmpty(vos) && Objects.nonNull(terminalDto)) {
            vos = auditExecuteIndicatorService.findListForVariable(terminalDto);
        }
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(vos)) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), vos.get(0).getIndicatorValue());
        return resultMap;
    }

    public AuditExecuteIndicatorDto buildParam(AuditExecuteIndicatorDto dto, CalculateDto calculateDto) {
        if (Objects.nonNull(dto)) {
            dto.setProductBrandCode(calculateDto.getBrandCode());
            dto.setProductCategoryCode(calculateDto.getCategoryCode());
            dto.setProductItemCode(calculateDto.getItemCode());
            dto.setProductCode(calculateDto.getProductCode());
        }
        return dto;
    }
}
