package com.biz.crm.tpm.business.variable.local.register.subcompany;

import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.tpm.business.variable.local.register.common.PriceRegisterParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.molecule.MoleculeIndexInventoryService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-28
 */
@Service
@Slf4j
public class SubCompanyStoreMonthAgeRegister extends MoleculeIndexInventoryService implements FormulaVariableRegister {
    private static final String INVENTORY_TYPE = "TERMINAL_INVENTORY";

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "subCompanyStoreMonthAge";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "月龄-门店（分子）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.WITHHOLDING);
        return functionList;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        this.moleculeValidate(calculateDto);

        BigDecimal months = super.getMonthDay(calculateDto, INVENTORY_TYPE, true);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), months);

        return resultMap;
    }

    private void moleculeValidate(CalculateDto calculate){

        Validate.notNull(calculate.getProductCode(), "产品编码不能为空");
        Validate.notNull(calculate.getSalesOrgCode(), "销售组织编码不能为空");
        Validate.notNull(calculate.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculate.getBusinessFormatCode(), "业态不能为空");
        Validate.notNull(calculate.getDate(), "调用日期不能为空");

    }
}
