package com.biz.crm.tpm.business.variable.local.register.subcompany.common;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * SAP出库类指标公共参数验证构建
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-20
 */
public class SapDeliveryRegisterParamBuilder {

    public static final String customer = "customer";
    public static final String terminal = "terminal";

    /**
     * SAP出库类指标公共参数验证构建
     *
     * @param calculateDto
     * @return
     */
    public static TpmSapDaySalesDto buildParam(CalculateDto calculateDto) {
        TpmSapDaySalesDto daySalesDto = buildCommonParam(calculateDto);
        daySalesDto.setDealerCodes(Arrays.asList(calculateDto.getCustomerErpCode().split(",")));
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            daySalesDto.setServiceCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
        }
        return daySalesDto;
    }


    /**
     * SAP出库类指标公共参数验证构建-售达方、送达方只有一个作为入参
     *
     * @param calculateDto
     * @return
     */
    public static List<TpmSapDaySalesDto> buildParamList(CalculateDto calculateDto) {
        List<TpmSapDaySalesDto> list = new ArrayList<>();
        TpmSapDaySalesDto customerDto = buildCommonParam(calculateDto);
        customerDto.setDealerCodes(Arrays.asList(calculateDto.getCustomerErpCode().split(",")));
        list.add(customerDto);
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            TpmSapDaySalesDto terminalDto = buildCommonParam(calculateDto);
            terminalDto.setServiceCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    public static TpmSapDaySalesDto buildCommonParam(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(calculateDto.getCustomerErpCode(), "客户MDG编码不能为空！");
        Validate.notBlank(calculateDto.getSalesOrganizationErpCode(), "销售机构MDG编码不能为空！");
        Validate.notBlank(calculateDto.getDistributionChannel(), "分销渠道不能为空！");

        TpmSapDaySalesDto daySalesDto = new TpmSapDaySalesDto();
        daySalesDto.setSpartCode(calculateDto.getBusinessFormatCode());
        daySalesDto.setSalesOrgCode(calculateDto.getSalesOrganizationErpCode());
        daySalesDto.setChannelCode(calculateDto.getDistributionChannel());
        List<String> brandList = new ArrayList<>();
        if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            brandList = Arrays.asList(calculateDto.getBrandCode().split(","));
        }
        if (!brandList.contains(VariableCommonConstants.allBrandCode)) {
            if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
                daySalesDto.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
            } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
                daySalesDto.setItemCodes(Arrays.asList(calculateDto.getItemCode().split(",")));
            } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
                daySalesDto.setCategoryCodeList(Arrays.asList(calculateDto.getCategoryCode().split(",")));
            } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
                daySalesDto.setBrandList(Arrays.asList(calculateDto.getBrandCode().split(",")));
            } else {
                throw new RuntimeException("产品编码、产品层级全部为空！");
            }
        }
        return daySalesDto;
    }
}
