package com.biz.crm.tpm.business.variable.local.register.subcompany.common;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-10
 */
@Service
public class SubComAuditExecutorIndicatorVariableService {
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public void valActivityNumber(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "活动细案明细编码不能为空");
    }

    public BigDecimal calActivityNumber(CalculateDto calculateDto) {
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setActiveNumber(calculateDto.getDetailPlanItemCode());
        List<AuditExecuteIndicatorVo> list = auditExecuteIndicatorService.findListForVariable(dto);
        if (CollectionUtils.isEmpty(list)) {
            return BigDecimal.ZERO;
        }
        return list.get(0).getIndicatorValue();
    }
}
