package com.biz.crm.tpm.business.variable.local.register.subcompany.common;

import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-05-31
 */
public class SubComSalesPlanParamBuilder {

    public static List<SalesPlanDto> buildOtherParamList(CalculateDto calculateDto) {
        List<SalesPlanDto> list = new ArrayList<>();
        SalesPlanDto customerDto = buildOtherParam(calculateDto);
        customerDto.setErpCode(calculateDto.getCustomerErpCode());
        list.add(customerDto);
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            SalesPlanDto terminalDto = buildOtherParam(calculateDto);
            terminalDto.setTerminalCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    private static SalesPlanDto buildOtherParam(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getCustomerErpCode(),"客户MDG编码不能为空");
        Validate.notNull(calculateDto.getYearMonthLy(),"年月不能为空");
        Validate.notNull(calculateDto.getBusinessFormatCode(),"业态不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(),"业务单元不能为空");

        SalesPlanDto salesPlan = new SalesPlanDto();
        salesPlan.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesPlan.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesPlan.setYearMonthLy(calculateDto.getYearMonthLy());
        salesPlan.setProductCode(calculateDto.getProductCode());
        return salesPlan;
    }
}
