package com.biz.crm.tpm.business.variable.local.register.subcompany.common;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-05-27
 */
@Service
public class SubComVariableSearchCommonService {

    @Autowired(required = false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    /**
     * 分子公司日销售报表-先用售达方（客户）查，查不到用送达方（终端门店）查，查不到返回空集合
     *
     * @param calculateDto
     * @return
     */
    public List<TpmSapDaySalesVo> tpmSapDaySalesVoList1(TpmSapDaySalesDto customerDto, TpmSapDaySalesDto terminalDto) {
        if (Objects.nonNull(customerDto)) {
            List<TpmSapDaySalesVo> list = tpmSapDaySalesService.listForVariable(customerDto);
            if (!CollectionUtils.isEmpty(list)) {
                return list;
            }
        }
        if (Objects.nonNull(terminalDto)) {
            List<TpmSapDaySalesVo> list = tpmSapDaySalesService.listForVariable(terminalDto);
            if (!CollectionUtils.isEmpty(list)) {
                return list;
            }
        }
        return Lists.newArrayList();
    }
}
