package com.biz.crm.tpm.business.variable.local.register.subcompany.common;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.SubComAuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-28
 */
@Component
public class SubCompanyExecuteIndicatorUtil {
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public BigDecimal getValue(CalculateDto calculateDto, String variableCode) {
        AuditExecuteIndicatorDto dto = AuditExecuteIndicatorParamBuilder.buildMainParam(calculateDto, variableCode);
        //第一优先级-优先级最高的是按活动明细编码查找唯一指标值（一对一精准导入指标结果）；
        List<AuditExecuteIndicatorVo> resultList = auditExecuteIndicatorService.findListForVariable(dto);
        if (!CollectionUtils.isEmpty(resultList)) {
            return resultList.get(0).getIndicatorValue();
        }
        //其它-活动明细编码没填写的，就按活动申请时所有字段与执行指标表中字段匹配查找唯一值
        List<AuditExecuteIndicatorDto> paramList = SubComAuditExecuteIndicatorParamBuilder.buildOtherParamList(calculateDto, variableCode);
        AuditExecuteIndicatorDto customerDto = paramList.get(0);
        AuditExecuteIndicatorDto terminalDto = paramList.get(1);
        if (Objects.nonNull(customerDto)) {
            resultList = auditExecuteIndicatorService.findListForVariable(customerDto);
        }
        if (Objects.nonNull(terminalDto) && CollectionUtils.isEmpty(resultList)) {
            resultList = auditExecuteIndicatorService.findListForVariable(terminalDto);
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            return resultList.get(0).getIndicatorValue();
        }
        return BigDecimal.ZERO;
    }
}
