package com.biz.crm.tpm.business.variable.local.register.subjectleveltwo;

import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ActivityDurationProductAfterAmountRegister
 * @description: 活动期间及活动产品折后任务额
 * @author: hb
 * @create: 2023-02-27 15:27
 */
@Service
public class ActivityDurationProductAfterAmountRegister extends SalesTaskService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "activityDurationProductAfterAmount";
    }

    @Override
    public String getVariableName() {
        return "活动期间及活动产品折后任务额（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        BigDecimal taskAfterAmount = this.getTaskAfterAmount(calculateDto, "contract");

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), taskAfterAmount);

        return resultMap;
    }
}
