package com.biz.crm.tpm.business.variable.local.register.subjectleveltwo;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ActivityDurationProductTaskQuantityRegister
 * @description: 活动期间及活动产品任务量
 * @author: hb
 * @create: 2023-02-27 10:56
 */
@Service
public class ActivityDurationProductTaskQuantityRegister extends SalesTaskService implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "activityDurationProductTaskQuantity";
    }

    @Override
    public String getVariableName() {
        return "活动期间及活动产品任务量（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);

        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        BigDecimal taskNumber = this.getTaskNumber(calculateDto, "contract");

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), taskNumber);

        return resultMap;
    }
}
