package com.biz.crm.tpm.business.variable.local.register.subjectleveltwo;

import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @className: SalesTaskService
 * @description: 销售任务Service
 * @author: hb
 * @create: 2023-02-27 10:57
 */
@Service
public abstract class SalesTaskService {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    public BigDecimal findSalesGoal(CalculateDto calculate, Integer queryType, String yearSalesTypeCode) {


        Validate.notNull(calculate.getCustomerCode(), "客户编码不能为空");
        Validate.notNull(calculate.getBusinessFormatCode(), "业态不能为空");
        Validate.notNull(calculate.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculate.getSalesOrgCode(), "销售组织不能为空");
        Validate.notNull(calculate.getYearMonthLy(), "年月不能为空");

        SalesGoalDto salesGoalDto = new SalesGoalDto();
        BeanUtils.copyProperties(calculate, salesGoalDto);
        salesGoalDto.setQueryType(queryType);
        salesGoalDto.setYearSalesTypeCode(yearSalesTypeCode);
        if (StringUtils.isNotEmpty(salesGoalDto.getProductCode())) {
            salesGoalDto.setProductItemCode(null);
            salesGoalDto.setProductCategoryCode(null);
            salesGoalDto.setProductBrandCode(null);
            salesGoalDto.setIncludeProductCodeList(Arrays.asList(salesGoalDto.getProductCode().split(",")));
            salesGoalDto.setProductCode(null);
        } else if (StringUtils.isNotEmpty(salesGoalDto.getProductItemCode())) {
            salesGoalDto.setProductCategoryCode(null);
            salesGoalDto.setProductBrandCode(null);
        } else if (StringUtils.isNotEmpty(salesGoalDto.getProductCategoryCode())) {
            salesGoalDto.setProductBrandCode(null);
        } else if (StringUtils.isNotEmpty(salesGoalDto.getProductBrandCode()) && StringUtils.equals(VariableCommonConstants.allBrandCode, salesGoalDto.getProductBrandCode())) {
            salesGoalDto.setProductBrandCode(null);
        }

        return salesGoalService.getSalesGoalAmount(salesGoalDto);
//        List<SalesGoalVo> queryResultList = salesGoalService.listByConditions(salesGoalDto);
//
//        List<SalesGoalVo> waitCalculationList = Lists.newArrayList();
//
//        if (CollectionUtils.isEmpty(queryResultList)) {
//            return waitCalculationList;
//        }
//
//        //获取产品不为空的
//        List<SalesGoalVo> salesGoalProductList = queryResultList
//                .stream()
//                .filter(salesGoalProduct -> StringUtils.isNotEmpty(salesGoalProduct.getProductCode()))
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(salesGoalProductList)) {
//            waitCalculationList.addAll(salesGoalProductList);
//        }
//        //产品为空，品项不为空
//        List<SalesGoalVo> salesGoalItemList = queryResultList
//                .stream()
//                .filter(salesGoal ->
//                        (StringUtils.isEmpty(salesGoal.getProductCode())
//                                && StringUtils.isNotEmpty(salesGoal.getProductItemCode())))
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(salesGoalItemList)) {
//            waitCalculationList.addAll(salesGoalItemList);
//        }
//        //产品、品项为空,品类不为空
//        List<SalesGoalVo> categoryList = queryResultList
//                .stream()
//                .filter(salesGoalVo -> (StringUtils.isEmpty(salesGoalVo.getProductCode())
//                        && StringUtils.isEmpty(salesGoalVo.getProductItemCode())
//                        && StringUtils.isNotEmpty(salesGoalVo.getProductCategoryCode())))
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(categoryList)) {
//            waitCalculationList.addAll(categoryList);
//        }
//        //产品、品项、品类为空,品牌不为空
//        List<SalesGoalVo> brandList = queryResultList
//                .stream()
//                .filter(salesGoal ->
//                        (StringUtils.isEmpty(salesGoal.getProductCode())
//                                && StringUtils.isEmpty(salesGoal.getProductItemCode())
//                                && StringUtils.isEmpty(salesGoal.getProductCategoryCode())
//                                && StringUtils.isNotEmpty(salesGoal.getProductBrandCode())))
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(brandList)) {
//            waitCalculationList.addAll(brandList);
//        }
//        if (CollectionUtils.isEmpty(brandList)) {
//            waitCalculationList.addAll(queryResultList);
//        }
//
//        return waitCalculationList;
    }

    public BigDecimal getTaskNumber(CalculateDto calculateDto, String yearSalesTypeCode){
        return this.findSalesGoal(calculateDto, 1, yearSalesTypeCode);
    }

    public BigDecimal getTaskAmount(CalculateDto calculateDto, String yearSalesTypeCode){
        return this.findSalesGoal(calculateDto, 2,yearSalesTypeCode);
    }

    public BigDecimal getTaskAfterAmount(CalculateDto calculateDto, String yearSalesTypeCode){

        return this.findSalesGoal(calculateDto,3, yearSalesTypeCode);

    }
}
