package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author: chenlong
 * @date: 2023/4/14 9:55
 * @description: 内控版销售任务出库数量
 */
@Slf4j
@Service
public class ControlSalesGoalDeliveryQuantityRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Override
    public String getVariableCode() {
        return "controlSalesGoalDeliveryQuantity";
    }

    @Override
    public String getVariableName() {
        return "内控版销售任务出库数量(垂直)";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "结束时间/日期不能为空");
        SalesGoalDto dto = new SalesGoalDto();
        dto.setYearMonthLy(DateUtil.dateToStr(DateUtil.date_yyyy_MM, calculateDto.getEndTimeOrDate()));
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setProductCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            dto.setProductBrandCode(calculateDto.getBrandCode());
        } else {
            throw new RuntimeException("内控版销售任务出库数量，未录入产品或者产品层级信息");
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setTerminalCode(calculateDto.getStoresCode());
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanCode(), "零售商编码为空");
            Validate.notBlank(calculateDto.getActivityOrgCode(), "区域编码为空");
            dto.setSystemCode(calculateDto.getRetailBusinessmanCode());
            dto.setRegionCode(calculateDto.getActivityOrgCode());
        }
        dto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
        SalesGoalSumVo salesGoalSumVo = salesGoalService.findDiscountAfterAndDeliveryQuantity(dto);

        //内控版销售任务出库数量
        BigDecimal deliveryQuantity = (Objects.nonNull(salesGoalSumVo) && Objects.nonNull(salesGoalSumVo.getDeliveryQuantity()))
                ? salesGoalSumVo.getDeliveryQuantity() : BigDecimal.ZERO;
        Map<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode(), deliveryQuantity);
        return resultMap;
    }
}
