package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @className: ReturnTaxIncluded
 * @description: 人员工资
 * @author: hb
 * @create: 2023-03-20 10:39
 */
@Slf4j
@Service
public class PersonnelSalaryRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private PromotersVoService promotersVoService;
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public String getVariableCode() {
        return "personnelSalary";
    }

    @Override
    public String getVariableName() {
        return "人员工资(垂直)";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String personCode = calculateDto.getPersonCode();
        Validate.notBlank(personCode, "人员编码不能为空!");
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空!");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元不能为空!");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "活动结束日期不能为空!");
        //将人员编码转换为外部智网编码编码
        PromotersVo promotersVo = this.promotersVoService.findByCode(personCode);
        Validate.notNull(promotersVo, "根据人员编码[%s]未查找到促销人员!",personCode);
        Validate.notBlank(promotersVo.getOutZwCode(), "根据人员编码[%s]查找到的促销人员外部智网编码为空!",personCode);
        String outZwCode = promotersVo.getOutZwCode();

        AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
        indicatorDto.setIndicatorName(QueryConstant.INDICATOR_NAME_PERSONNEL_SALARY);
        indicatorDto.setPersonCode(outZwCode);
        indicatorDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        indicatorDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());

        indicatorDto.setYearAndMonth(DateUtil.strToDate(DateUtil.dateToStr(
                calculateDto.getEndTimeOrDate(),DateUtil.date_yyyy_MM),DateUtil.date_yyyy_MM));
        log.error("查询人员工资入参：{}", JSONObject.toJSONString(indicatorDto));
        List<AuditExecuteIndicatorVo> byCode = auditExecuteIndicatorService.getPersonnelWage(indicatorDto);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        if (CollectionUtils.isEmpty(byCode)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), byCode.get(0).getIndicatorValue());
        return resultMap;
    }
}
