package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.returns.order.sdk.dto.ReturnOrderDto;
import com.biz.crm.kms.business.invoice.returns.order.sdk.service.ReturnOrderVoService;
import com.biz.crm.kms.business.invoice.returns.order.sdk.vo.ReturnOrderVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @className: ReturnTaxIncluded
 * @description: 退货含税金额
 * @author: hb
 * @create: 2023-03-20 10:39
 */
@Slf4j
@Service
public class ReturnTaxIncluded implements FormulaVariableRegister {

    @Autowired(required = false)
    ReturnOrderVoService returnOrderVoService;

    @Autowired(required = false)
    ProductVoService productVoService;

    @Autowired(required = false)
    TerminalVoService terminalVoService;

    @Override
    public String getVariableCode() {
        return "returnTaxIncluded";
    }

    @Override
    public String getVariableName() {
        return "退货含税金额（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.CONTRACT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        //kms没有存品牌品类品项 零售商、区域等字段 没有产品/终端维度就得去查
        Validate.notNull(calculateDto.getStartTimeOrDate(), "退货含税金额，未传入开始日期");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "退货含税金额，未传入结束日期");
        ReturnOrderDto dto = new ReturnOrderDto();
        dto.setStartDate(DateUtil.dateToStr(calculateDto.getStartTimeOrDate(),DateUtil.date_yyyy_MM_dd));
        dto.setEndDate(DateUtil.dateToStr(calculateDto.getEndTimeOrDate(),DateUtil.date_yyyy_MM_dd));
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setProductCodeList(Lists.newArrayList(calculateDto.getProductCode()));
        } else if (CollectionUtils.isNotEmpty(calculateDto.getProductCodeSetForVertical())) {
            dto.setProductCodeList(Lists.newArrayList(calculateDto.getProductCodeSetForVertical()));
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode()) || StringUtils.isNotEmpty(calculateDto.getCategoryCode()) || StringUtils.isNotEmpty(calculateDto.getBrandCode())){
            ProductQueryDto productQueryDto = new ProductQueryDto();
            if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
                productQueryDto.setProductLevelCode(calculateDto.getItemCode());
            } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
                productQueryDto.setProductCategoryCode(calculateDto.getCategoryCode());
            } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
                productQueryDto.setProductBrandCode(calculateDto.getBrandCode());
            } else {
                throw new RuntimeException("退货含税金额，未录入产品或者产品层级信息");
            }
            List<ProductVo> productVoList = productVoService.findByProductQueryDto(productQueryDto);
            Validate.isTrue(CollectionUtils.isNotEmpty(productVoList), "退货含税金额，根据当前条件未找到任何产品");
            Set<String> productCodeSet = productVoList.stream().map(ProductVo::getProductCode).collect(Collectors.toSet());
            calculateDto.setProductCodeSetForVertical(productCodeSet);
            dto.setProductCodeList(Lists.newArrayList(productCodeSet));
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setTerminalCodeList(Lists.newArrayList(calculateDto.getStoresCode()));
        } else if (CollectionUtils.isNotEmpty(calculateDto.getTerminalCodeSetForVertical())) {
            dto.setTerminalCodeList(Lists.newArrayList(calculateDto.getTerminalCodeSetForVertical()));
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanCode(), "零售商编码为空");
            Validate.notBlank(calculateDto.getActivityOrgCode(), "区域编码为空");
            TerminalSearchDto terminalSearchDto = new TerminalSearchDto();
            terminalSearchDto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
            terminalSearchDto.setRegionCode(calculateDto.getActivityOrgCode());
            terminalSearchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            List<TerminalVo> terminalVoList = terminalVoService.findByTerminalSearchDto(terminalSearchDto);
            Validate.isTrue(CollectionUtils.isNotEmpty(terminalVoList), "退货含税金额，根据当前条件未找到任何门店");
            Set<String> terminalCodeSet = terminalVoList.stream().map(TerminalVo::getTerminalCode).collect(Collectors.toSet());
            calculateDto.setTerminalCodeSetForVertical(terminalCodeSet);
            dto.setTerminalCodeList(Lists.newArrayList(terminalCodeSet));
        }
        dto.setExcludeProductCodeList(calculateDto.getExcludeProductCodeList());
        ReturnOrderVo result = returnOrderVoService.findAmountForVariable(dto);
        log.error("退货含税金额feign返回:{}", result);
        Map<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (Objects.nonNull(result) && Objects.nonNull(result.getReturnAmount())) {
            resultMap.put(this.getVariableCode(), result.getReturnAmount());
        }
        return resultMap;
    }
}
