package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 折后出库达成率（垂直）
 */
@Service
@Slf4j
public class VerticalAfterDiscountDeliveryYieldRateRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPerformanceService salesPerformanceService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Override
    public String getVariableCode() {
        return "verticalAfterDiscountDeliveryYieldRate";
    }

    @Override
    public String getVariableName() {
        return "折后出库达成率（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
        SalesPerformanceDto dto = new SalesPerformanceDto();
        String yearMonthLy = calculateDto.getYearMonthLy();
        dto.setSalesMonth(yearMonthLy.replaceAll("-", ""));
        //不是下面设置值错了，是这张表字段错了
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setMaterialCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setCategoryCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setClassify(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            dto.setBrand(calculateDto.getBrandCode());
        } else {
            throw new RuntimeException("垂直实际销售额，未录入产品或者产品层级信息");
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setShipToparty(calculateDto.getStoresCode());
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanName(), "零售商名称为空");
            Validate.notBlank(calculateDto.getActivityOrgName(), "区域名称为空");
            dto.setRetailer(calculateDto.getRetailBusinessmanName());
            dto.setRegion(calculateDto.getActivityOrgName());
        }
        SalesPerformanceVo salesPerformanceVo = salesPerformanceService.findSalesAmountAndOutNumber(dto);

        //垂直实际销售额
        BigDecimal verticalRealitySalesAmount = (Objects.nonNull(salesPerformanceVo) && Objects.nonNull(salesPerformanceVo.getWarehsOutDiscountAmt()))
                ? salesPerformanceVo.getWarehsOutDiscountAmt() : BigDecimal.ZERO;
        Map<String, BigDecimal> resultMap = new HashMap<>(4);

        //绩效版销售任务折后额
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "结束时间/日期不能为空");
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setYearMonthLy(DateUtil.dateToStr(DateUtil.date_yyyy_MM, calculateDto.getEndTimeOrDate()));
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            salesGoalDto.setProductCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            salesGoalDto.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            salesGoalDto.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            salesGoalDto.setProductBrandCode(calculateDto.getBrandCode());
        } else {
            throw new RuntimeException("绩效版销售任务折后额，未录入产品或者产品层级信息");
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            salesGoalDto.setTerminalCode(calculateDto.getStoresCode());
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanCode(), "零售商编码为空");
            Validate.notBlank(calculateDto.getActivityOrgCode(), "区域编码为空");
            salesGoalDto.setSystemCode(calculateDto.getRetailBusinessmanCode());
            salesGoalDto.setRegionCode(calculateDto.getActivityOrgCode());
        }
        salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.ACHIEVEMENT.getCode());
        SalesGoalSumVo salesGoalSumVo = salesGoalService.findDiscountAfterAndDeliveryQuantity(salesGoalDto);

        BigDecimal deliveryDiscountSalesAmount = (Objects.nonNull(salesGoalSumVo) && Objects.nonNull(salesGoalSumVo.getDeliveryDiscountSalesAmount()))
                ? salesGoalSumVo.getDeliveryDiscountSalesAmount() : BigDecimal.ZERO;

        if (BigDecimal.ZERO.compareTo(deliveryDiscountSalesAmount) == 0) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), verticalRealitySalesAmount.divide(deliveryDiscountSalesAmount, 4, RoundingMode.HALF_UP));
        return resultMap;
    }
}
