package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 开单系数（垂直）
 */
@Service
@Slf4j
public class VerticalBillingCoefficientRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPerformanceService salesPerformanceService;

    @Override
    public String getVariableCode() {
        return "verticalBillingCoefficient";
    }

    @Override
    public String getVariableName() {
        return "开单系数（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
        SalesPerformanceDto dto = new SalesPerformanceDto();
        String yearMonth = calculateDto.getYearMonthLy().replaceAll("-", "");
        dto.setSalesMonth(yearMonth);
        //不是下面设置值错了，是这张表字段错了
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setMaterialCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setCategoryCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setClassify(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            dto.setBrand(calculateDto.getBrandCode());
        } else {
            throw new RuntimeException("开单系数（垂直），未录入产品或者产品层级信息");
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setShipToparty(calculateDto.getStoresCode());
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanName(), "零售商名称为空");
            Validate.notBlank(calculateDto.getActivityOrgName(), "区域名称为空");
            dto.setRetailer(calculateDto.getRetailBusinessmanName());
            dto.setRegion(calculateDto.getActivityOrgName());
        }
        SalesPerformanceVo allSalesPerformanceVo = salesPerformanceService.findSalesAmountAndOutNumber(dto);

        Map<String, BigDecimal> resultMap = new HashMap<>(4);
        //全月折前出库金额
        BigDecimal allOrderRuleAmtInRebate = (Objects.nonNull(allSalesPerformanceVo) && Objects.nonNull(allSalesPerformanceVo.getOrderRuleAmtInRebate()))
                ? allSalesPerformanceVo.getOrderRuleAmtInRebate() : BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(allOrderRuleAmtInRebate) == 0) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        //上中旬（1-20号）折前出库金额
        dto.setStartDate(yearMonth + "01");
        dto.setEndDate(yearMonth + "20");
        SalesPerformanceVo salesPerformanceVo = salesPerformanceService.findSalesAmountAndOutNumber(dto);
        BigDecimal orderRuleAmtInRebate = (Objects.nonNull(salesPerformanceVo) && Objects.nonNull(salesPerformanceVo.getOrderRuleAmtInRebate()))
                ? salesPerformanceVo.getOrderRuleAmtInRebate() : BigDecimal.ZERO;

        //开单系数=上中旬（1-20号）折前出库金额/全月折前出库金额
        BigDecimal verticalBillingCoefficient = orderRuleAmtInRebate.divide(allOrderRuleAmtInRebate, 4, RoundingMode.HALF_UP);
        resultMap.put(this.getVariableCode(), verticalBillingCoefficient);
        return resultMap;
    }
}
