package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

/**
 * 垂直手续费点数
 */
@Service
@Slf4j
public class VerticalCommissionPointRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required = false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    @Override
    public String getVariableCode() {
        return "verticalCommissionPoint";
    }

    @Override
    public String getVariableName() {
        return "手续费点数（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getDetailPlanItemCode(),"活动细案明细编码不能为空");
        BigDecimal amount = BigDecimal.ZERO;

        if (Boolean.TRUE.equals(calculateDto.getIsDiffTrack())) {
            List<AuditFeeDiffTrackDetailVo> detailVos = auditFeeDiffTrackDetailVoService.findByDetailCodes(Lists.newArrayList(calculateDto.getDetailPlanItemCode()));
            AuditFeeDiffTrackDetailVo detailVo = CollectionUtils.isEmpty(detailVos) ? null : detailVos.get(0);
            if(detailVo != null){
                amount = Optional.ofNullable(detailVo.getCommissionPoint()).orElse(BigDecimal.ZERO);
            }
        } else {
            ActivityDetailPlanItemVo detailPlanItemVo = activityDetailPlanItemService.findDetailPlanItemByItemCode(calculateDto.getDetailPlanItemCode());
            if(detailPlanItemVo != null){
                amount = Optional.ofNullable(detailPlanItemVo.getCommissionPoint()).orElse(BigDecimal.ZERO);
            }
        }
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(),amount);
        return resultMap;
    }
}
